<?php
// Activar errores para depuración (eliminar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 1. Manejar actualización del tipo
if (isset($_POST['adType'])) {
    $jsonFilePath = __DIR__ . '/includes/ad_type.json';
    
    // Validar valor recibido
    $allowedTypes = ['manual', 'tmdb'];
    $newType = in_array($_POST['adType'], $allowedTypes) ? $_POST['adType'] : 'manual';
    
    // Guardar en JSON
    file_put_contents($jsonFilePath, json_encode(['adType' => $newType]));
    exit;
}

// 2. Mostrar interfaz
include ('includes/header.php');
?>

<div class="card bg-dark text-white">
    <div class="card-header card-header-warning text-center">
        <h4><i class="fa fa-toggle-on"></i> Selector de Anuncios</h4>
    </div>
    <div class="card-body text-center">
        <!-- Switch con estado persistente -->
        <div class="d-flex align-items-center justify-content-center mb-4">
            <span class="me-3 fw-bold fs-5 <?= ($currentAdType === 'manual') ? 'text-white' : 'text-muted' ?>">Manual</span>
            
            <label class="switch-enhanced">
                <input type="checkbox" id="adTypeSlider" <?= ($currentAdType === 'tmdb') ? 'checked' : '' ?>>
                <span class="slider-enhanced round-enhanced"></span>
            </label>
            
            <span class="ms-3 fw-bold fs-5 <?= ($currentAdType === 'tmdb') ? 'text-white' : 'text-muted' ?>">Auto/TMDB</span>
        </div>
        
        <!-- Estado actual -->
        <div id="statusText" class="badge <?= ($currentAdType === 'tmdb') ? 'bg-info' : 'bg-primary' ?> fs-6 p-2">
            <i class="fa fa-<?= ($currentAdType === 'tmdb') ? 'film' : 'hand-paper-o' ?> me-2"></i>
            Modo actual: <?= strtoupper($currentAdType) ?>
        </div>
        
        <!-- Botones de acción -->
        <div class="d-flex justify-content-center gap-4 mt-4">
            <a href="ads.php" class="btn btn-primary btn-lg mx-3">
                <i class="fa fa-hand-paper-o me-2"></i> Envío Manual
            </a>
            <a href="tmdb_api.php" class="btn btn-info btn-lg mx-3">
                <i class="fa fa-film me-2"></i> Api TMDB
            </a>
        </div>
    </div>
</div>

<script>
// Función para actualizar el estado
function updateAdType() {
    const slider = document.getElementById('adTypeSlider');
    const adType = slider.checked ? 'tmdb' : 'manual';
    
    // Feedback visual inmediato
    document.getElementById('statusText').className = `badge ${slider.checked ? 'bg-info' : 'bg-primary'} fs-6 p-2`;
    document.getElementById('statusText').innerHTML = 
        `<i class="fa fa-${slider.checked ? 'film' : 'hand-paper-o'} me-2"></i> Modo actual: ${adType.toUpperCase()}`;

    // Enviar al servidor
    fetch('ad_type.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'adType=' + adType
    }).catch(error => {
        console.error("Error:", error);
        alert("Error al guardar el modo. Recarga la página.");
    });
}

// Inicialización
document.getElementById('adTypeSlider').addEventListener('change', updateAdType);
</script>

<?php include ('includes/footer.php'); ?>