<?php
include "includes/header.php";
?>
<style>
  .custom-button {
    padding: 10px 20px;
  }
  /* Estructura de layout para sidebar y contenido */
  .page-container {
    display: flex;
    transition: all 0.3s ease;
  }
  .page-sidebar {
    width: 250px;
    transition: width 0.3s ease;
  }
  .page-container.sidebar-collapsed .page-sidebar {
    width: 80px;
  }
  .preview-video {
    width: 100%;
    height: auto;
  }
</style>

<div class="page-container" id="page-container">
    <div class="mx-auto px-3" style="max-width: 700px;">
        <div class="card border-left-primary shadow h-100 card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-secondary">
                    <i class="fa fa-film"></i> Actualización de Video Intro
                </h6>
            </div>
            <div class="card-body">
                <?php
                // Ruta del video
                $videoPath = 'splash_rgvip/intro.mp4';

                // Ruta del JSON de configuración
                $configFile = 'api/intro_config.json';

                // Crear JSON si no existe
                if (!file_exists($configFile)) {
                    $defaultConfig = ['intro_enabled' => true];
                    file_put_contents($configFile, json_encode($defaultConfig, JSON_PRETTY_PRINT));
                }

                // Leer configuración actual
                $config = json_decode(file_get_contents($configFile), true);
                $introEnabled = $config['intro_enabled'] ?? true;

                // Procesar activación/desactivación del intro
                if (isset($_POST['toggle_intro'])) {
                    $newStatus = ($_POST['status'] === '1');
                    $config['intro_enabled'] = $newStatus;
                    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
                    echo "<script>window.location.href=window.location.href;</script>";
                }

                // Mostrar video solo si está habilitado
                if ($introEnabled && file_exists($videoPath)) {
                    $timestamp = filemtime($videoPath); // Evitar cache del navegador
                    echo '<h3>Video Actual:</h3>';
                    echo '<video class="preview-video" controls preload="auto" playsinline>';
                    echo '<source src="' . $videoPath . '?v=' . $timestamp . '" type="video/mp4">';
                    echo 'Tu navegador no soporta la etiqueta de video.';
                    echo '</video>';
                } else {
                    echo '<p>El video intro está desactivado o no existe.</p>';
                }

                // Procesar subida de nuevo video
                if (isset($_POST['upload']) && isset($_FILES['video'])) {
                    $file = $_FILES['video'];
                    $fileType = $file['type'];
                    $fileTemp = $file['tmp_name'];
                    $allowedTypes = ['video/mp4'];
                    if (in_array($fileType, $allowedTypes)) {
                        $destination = 'splash_rgvip/intro.mp4';
                        if (move_uploaded_file($fileTemp, $destination)) {
                            clearstatcache();
                            echo "<script>window.location.href=window.location.href;</script>";
                        } else {
                            echo '<div class="alert alert-danger mt-3">Error al mover el archivo.</div>';
                        }
                    } else {
                        echo '<div class="alert alert-warning mt-3">Formato no permitido. Solo se permite MP4.</div>';
                    }
                }
                ?>

                <!-- Formulario para subir video -->
                <form method="post" enctype="multipart/form-data" class="mt-4">
                    <label for="video">Selecciona un video (.mp4):</label>
                    <input type="file" name="video" id="video" accept="video/mp4" required class="form-control mb-2">
                    <button type="submit" class="custom-button btn btn-success btn-icon-split" name="upload">Guardar</button>
                </form>

                <!-- Formulario para activar/desactivar intro -->
                <form method="post" class="mt-4">
                    <label for="status">Estado del intro:</label>
                    <select name="status" id="status" class="form-control mb-2">
                        <option value="1" <?= $introEnabled ? 'selected' : '' ?>>Activado</option>
                        <option value="0" <?= !$introEnabled ? 'selected' : '' ?>>Desactivado</option>
                    </select>
                    <button type="submit" name="toggle_intro" class="btn btn-warning">
                        Guardar Estado
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
  document.getElementById('toggle-menu')?.addEventListener('click', function (e) {
    e.preventDefault();
    document.getElementById('page-container').classList.toggle('sidebar-collapsed');
  });
</script>

<?php include "includes/footer.php"; ?>
</body>
</html>
